param (
    [string]$ZipPath,
    [string]$TargetDir,
    [string]$ProcessName = "GameCore.Master"
)

Start-Sleep -Seconds 3

# Wait for process to exit
$process = Get-Process -Name $ProcessName -ErrorAction SilentlyContinue
if ($process) {
    Stop-Process -Name $ProcessName -Force -ErrorAction SilentlyContinue
    $process.WaitForExit()
}

# Expand Archive
Expand-Archive -Path $ZipPath -DestinationPath $TargetDir -Force

# Restart Service/Process (Assuming it's run as a service or just start exe)
# If it was running as a service, we should probably use sc start/stop, but for now specific exe
if (Test-Path "$TargetDir\GameCore.Master.exe") {
    Start-Process "$TargetDir\GameCore.Master.exe"
} elseif (Test-Path "$TargetDir\GameCore.Node.exe") {
    Start-Process "$TargetDir\GameCore.Node.exe"
}

# Cleanup
Remove-Item -Path $ZipPath -Force
